/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.lang.reflect.Modifier;
import java.util.Vector;

class SerializableTest {
    private Class m_rootClass = null;
    private Vector m_inspectedClass = new Vector(20);

    protected SerializableTest(String clsName) throws Exception {
        this.m_rootClass = Class.forName(clsName);
        this.m_inspectedClass.add(this.m_rootClass);
    }

    protected void inspect() throws Exception {
        this.inspect(this.m_rootClass, "");
    }

    private static String getUserFriendlyClassName(Class fieldCls, String fieldClsName) throws ClassNotFoundException {
        String res = fieldClsName;
        if (fieldCls.isArray()) {
            int start = fieldClsName.indexOf("[L");
            int semiColonIndex = fieldClsName.lastIndexOf(";");
            if (semiColonIndex > 0) {
                String realClass = fieldClsName.substring(start + 2, semiColonIndex);
                res = realClass + "[] ";
            }
        }
        return res + " ";
    }

    private static String getSuperClassName(Class theClass) {
        Class superClass = theClass.getSuperclass();
        if (superClass != null && !superClass.getName().startsWith("java.")) {
            return " (extends " + theClass.getSuperclass().getName() + ")";
        }
        return "";
    }

    protected void inspect(Class cls, String prefix) throws Exception {
        ObjectStreamClass oscCls;
        if (cls == null) {
            return;
        }
        if (cls.getName().startsWith("java.") || cls.getName().startsWith("javax.")) {
            return;
        }
        this.m_inspectedClass.add(cls);
        System.out.println(prefix + "{ //" + cls.getCanonicalName() + SerializableTest.getSuperClassName(cls));
        Class superCls = cls.getSuperclass();
        if (superCls != null && !this.m_inspectedClass.contains(superCls)) {
            this.inspect(superCls, prefix);
        }
        if ((oscCls = ObjectStreamClass.lookup(cls)) == null) {
            String reason = "[UNKNOWN]}";
            if (cls.isInterface()) {
                reason = "[INTERFACE]}";
            } else if (Modifier.isAbstract(cls.getModifiers())) {
                reason = "[ABSTRACT?]}";
            }
            System.out.println("*** " + cls.getCanonicalName() + " does not implement Serializable " + reason);
            return;
        }
        ObjectStreamField[] fields = oscCls.getFields();
        int nFields = fields == null ? 0 : fields.length;
        System.out.println(prefix + "  " + cls.getCanonicalName() + " has " + nFields + " fields");
        for (int i = 0; i < nFields; ++i) {
            boolean seenThis;
            Class<?> fieldCls = fields[i].getType();
            String fieldClsName = fields[i].getType().getName();
            boolean bl = seenThis = this.m_inspectedClass.contains(fieldCls) && !fields[i].isPrimitive() && fieldClsName.indexOf("java.") == -1;
            if (!seenThis) {
                this.m_inspectedClass.add(fieldCls);
            }
            System.out.println(prefix + "  " + i + ":" + SerializableTest.getUserFriendlyClassName(fieldCls, fieldClsName) + fields[i].getName() + (seenThis ? " (*seen*)" : ""));
            if (fields[i].isPrimitive() || seenThis) continue;
            if (fieldCls.isArray()) {
                int start = fieldClsName.indexOf("[L");
                int semiColonIndex = fieldClsName.lastIndexOf(";");
                if (semiColonIndex > 0) {
                    String realClass = fieldClsName.substring(start + 2, semiColonIndex);
                    fieldCls = Class.forName(realClass);
                }
            }
            this.inspect(fieldCls, prefix + "    ");
        }
        System.out.println(prefix + "} //" + cls.getCanonicalName());
    }
}

